<?php
session_start();
require 'conexao.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Configurações e variáveis
$msgsis2 = $_SESSION['msg2'] ?? '';
$user_id = $_SESSION['user_name'];
$precomadeira = "27";
$_SESSION['precomadeira'] = $precomadeira;
$precocarne = "36";
$_SESSION['precocarne'] = $precocarne;

// Notificações
$sqlCountNotificacoes = "SELECT COUNT(*) AS total_notificacoes FROM notificacoes_jogo WHERE user2 = :user_name AND vz2 = 0";
$stmtCountNotificacoes = $pdo->prepare($sqlCountNotificacoes);
$stmtCountNotificacoes->bindParam(':user_name', $user_id, PDO::PARAM_STR);
$stmtCountNotificacoes->execute();
$resultado = $stmtCountNotificacoes->fetch(PDO::FETCH_ASSOC);
$total_notificacoes = $resultado['total_notificacoes'];

// Processar seleção de personagem
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['personagem'])) {
    $_SESSION['personagem'] = $_POST['personagem'];
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Buscar mensagens do sistema


// Buscar descrição do local quando um quadrado do mapa for clicado
if (isset($_GET['location'])) {
    $location = $_GET['location'];
    $sqlLocation = "SELECT descricao FROM mapasmed WHERE nome = :location";
    $stmtLocation = $pdo->prepare($sqlLocation);
    $stmtLocation->bindParam(':location', $location, PDO::PARAM_STR);
    $stmtLocation->execute();
    $locationInfo = $stmtLocation->fetch(PDO::FETCH_ASSOC);
    
    if ($locationInfo) {
        echo $locationInfo['descricao'];
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Medieval Fantasy - Dervian</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=MedievalSharp&display=swap">
    <link rel="stylesheet" type="text/css" href="style.css">
    <style>
        :root {
            --azul-vivo: #0000FF;
            --azul-hover: #1E90FF;
            --azul-escuro: #00008B;
            --marrom: #8B4513;
            --marrom-claro: #A0522D;
            --ouro: #D4AF37;
            --prata: #C0C0C0;
            --preto: #000000;
            --branco: #FFFFFF;
            --cinza: #808080;
            --vermelho: #FF0000;
            --verde: #00FF00;
        }
        
        body {
            font-family: 'MedievalSharp', cursive;
            background-color: var(--preto);
            color: var(--branco);
            margin: 0;
            padding: 0;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
            background-color: rgba(0, 0, 0, 0.8);
            border: 5px solid var(--azul-vivo);
            box-shadow: 0 0 20px var(--azul-vivo);
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            position: relative;
        }
        
        .banner {
            max-width: 100%;
            height: auto;
            border-bottom: 3px solid var(--azul-vivo);
        }
        
        .welcome {
            font-size: 2rem;
            color: var(--azul-vivo);
            text-shadow: 0 0 10px var(--azul-vivo);
            margin: 10px 0;
        }
        
        .btn {
            display: inline-block;
            padding: 12px 24px;
            margin: 5px;
            background: var(--azul-escuro);
            color: var(--branco);
            border: 3px solid var(--azul-vivo);
            border-radius: 8px;
            font-family: 'MedievalSharp', cursive;
            font-size: 1.1rem;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
        }
        
        .btn:hover {
            background: var(--azul-vivo);
            transform: translateY(-3px);
            box-shadow: 0 0 15px var(--azul-vivo);
        }
        
        .btn-menu {
            background: var(--azul-escuro);
            color: var(--branco);
            font-weight: bold;
        }
        
        .btn-danger {
            background: var(--vermelho);
            border-color: var(--vermelho);
        }
        
        .btn-success {
            background: var(--verde);
            border-color: var(--verde);
        }
        
        .btn-warning {
            background: var(--ouro);
            border-color: var(--ouro);
            color: var(--preto);
        }
        
        .character-section {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .character-selector {
            flex: 1;
            min-width: 300px;
            background: rgba(0, 0, 139, 0.3);
            padding: 20px;
            border-radius: 10px;
            border: 2px solid var(--azul-vivo);
        }
        
        .character-info {
            flex: 2;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
        }
        
        .info-card {
            background: rgba(0, 0, 0, 0.7);
            padding: 15px;
            border-radius: 8px;
            border-left: 5px solid var(--azul-vivo);
            box-shadow: 0 0 10px rgba(0, 0, 255, 0.5);
        }
        
        .info-card h3 {
            margin-top: 0;
            color: var(--azul-vivo);
            border-bottom: 1px dashed var(--azul-vivo);
            padding-bottom: 5px;
        }
        
        select {
           width: 98%;
            padding: 12px;
            border: 2px solid var(--azul-vivo);
            border-radius: 6px;
            background: var(--preto);
            color: var(--branco);
            font-family: 'MedievalSharp', cursive;
            font-size: 1rem;
            margin-bottom: 15px;
        }
        
        .map-container {
            position: relative;
            left: -120px;
            display: grid;
            grid-template-columns: repeat(6, 1fr);
            grid-template-rows: repeat(6, 1fr);
            width: 300px;
            margin: 0 auto;
        }
        
        .map-square {
            height: 100px;
            border: 1px solid var(--azul-vivo);
            text-align: center;
            margin: 0;
            position: relative;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .map-square:hover {
            transform: scale(1.05);
            z-index: 2;
            box-shadow: 0 0 15px var(--azul-vivo);
        }
        
        .map-image {
            width: 80px;
            height: 80px;
            margin: 5px;
            z-index: -1;
        }
        
        .map-name {
            position: absolute;
            top: -12%;
            left: 0;
            right: 0;
            text-align: center;
            z-index: 2;
            color: var(--azul-vivo);
            font-weight: bold;
            text-shadow: 1px 1px 2px var(--preto);
        }
        
        .map-personagem {
            position: absolute;
            top: 30%;
            left: 0;
            right: 0;
            text-align: center;
            z-index: 2;
        }
        
        .actions-section {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-top: 30px;
        }
        
        .action-group {
            height: 92%;
            background: rgba(0, 0, 0, 0.7);
            padding: 20px;
            border-radius: 10px;
            border: 2px solid var(--azul-vivo);
            box-shadow: 0 0 10px rgba(0, 0, 255, 0.5);
        }
        
        .action-group h2 {
            color: var(--azul-vivo);
            margin-top: 0;
            border-bottom: 2px solid var(--azul-vivo);
            padding-bottom: 10px;
        }
        
        input[type="number"] {
           width: 98%;
            padding: 10px;
            margin: 10px 0;
            border: 2px solid var(--azul-vivo);
            border-radius: 6px;
            background: var(--preto);
            color: var(--branco);
            font-family: 'MedievalSharp', cursive;
        }
        
        .footer {
            text-align: center;
            margin-top: 40px;
            padding: 20px;
            border-top: 3px solid var(--azul-vivo);
            font-size: 1.5rem;
            color: var(--azul-vivo);
        }
        
        .notification-badge {
            position: absolute;
            top: -10px;
            right: -10px;
            background: var(--vermelho);
            color: white;
            border-radius: 50%;
            width: 25px;
            height: 25px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.8rem;
        }
        
        .btn-notification {
            position: relative;
        }
        
        .messages-container {
            background: rgba(0, 0, 0, 0.7);
            border: 2px solid var(--azul-vivo);
            border-radius: 10px;
            padding: 15px;
            margin: 20px 0;
            max-height: 200px;
            overflow-y: auto;
        }
        
        .message {
            padding: 8px;
            border-bottom: 1px dashed var(--azul-vivo);
            color: var(--branco);
        }
        
        .message:last-child {
            border-bottom: none;
        }
        
        .modal {
            display: none;
            position: fixed;
            z-index: 100;
            left: 0;
            top: 0;
           width: 98%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
        }
        
        .modal-content {
            background-color: var(--preto);
            margin: 15% auto;
            padding: 20px;
            border: 3px solid var(--azul-vivo);
            width: 80%;
            max-width: 600px;
            color: var(--branco);
            position: relative;
        }
        
        .close-modal {
            color: var(--azul-vivo);
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
        
        .close-modal:hover {
            color: var(--azul-hover);
        }
        
        @media (max-width: 768px) {
            .character-section {
                flex-direction: column;
            }
            
            .map-container {
                left: 0;
               width: 98%;
                grid-template-columns: repeat(3, 1fr);
            }
        }

          /* Modal Personagens - Estilo Atualizado */
    #modalPersonagens {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
       width: 98%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.8);
        overflow: auto;
    }
    
    #modalPersonagens .modal-content {
        background-color: var(--preto);
        margin: auto;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        padding: 20px;
        border: 3px solid var(--azul-vivo);
        width: 80%;
        max-width: 650px;
        max-height: 80vh;
        overflow-y: auto;
        color: var(--branco);
        box-shadow: 0 0 20px rgba(0, 0, 255, 0.5);
    }
    
    #modalPersonagens .close-modal {
        color: var(--azul-vivo);
        float: right;
        font-size: 28px;
        font-weight: bold;
        cursor: pointer;
        transition: color 0.3s;
    }
    
    #modalPersonagens .close-modal:hover {
        color: var(--azul-hover);
    }
    
    /* Scrollbar dentro do modal */
    #modalPersonagens .modal-content::-webkit-scrollbar {
        width: 8px;
    }
    
    #modalPersonagens .modal-content::-webkit-scrollbar-track {
        background: #001a33;
    }
    
    #modalPersonagens .modal-content::-webkit-scrollbar-thumb {
        background: #0066cc;
        border-radius: 4px;
    }
    
    #modalPersonagens .modal-content::-webkit-scrollbar-thumb:hover {
        background: #0099ff;
    }
</style>
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="bn.png" alt="Medieval Fantasy" class="banner">
            <h1 class="welcome">Bem-vindo, <?php echo htmlspecialchars($_SESSION['user_name']); ?></h1>
            
            <div class="navigation">
                <a href="dashboard.php" class="btn btn-menu">Menu Principal</a>
                <a href="pagina_notificacoesjogo.php" class="btn btn-notification">
                    Notificações
                    <?php if ($total_notificacoes >= 1): ?>
                        <span class="notification-badge"><?php echo $total_notificacoes; ?></span>
                    <?php endif; ?>
                </a>
                <a href="javascript:void(0);" onclick="confirmarSaida()" class="btn btn-danger">Sair</a>
            </div>
        </div>
        
   
        
        <!-- Seção de Seleção de Personagem -->
        <div class="character-section">
            <div class="character-selector">
               <?php
// Consulta para encontrar o personagem ativo (situacao != 0)
$vendendo = "vendendo";
$sql = "SELECT * FROM personagens WHERE jogador = :user_id AND ativo = 1 LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    $personagemAtivo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Define o personagem ativo na sessão
    $_SESSION['personagem'] = $personagemAtivo['id'];
    $_SESSION['personagem_nome'] = $personagemAtivo['personagem'];
 
    
    // SE TIRAR ESSA DIV OS TAMANHOS FICAM INCORRETOS
    echo '<div class="personagem-detalhes">';
     echo '<h2>Seu personagem </h2>';
    // Continue com outros campos conforme necessário
    echo '</div>';
} else {
    echo '<div class="nenhum-personagem-ativo">';
    echo '<p>Nenhum personagem ativo encontrado.</p>';
    echo '<p>Por favor, <a href="ativarpersonagens.php">ative um personagem</a> para continuar.</p>';
    echo '</div>';
}

                 if (1 > 0) {
                    
                    // Mostrar informações do personagem selecionado
                    if (isset($_SESSION['personagem'])) {
                        $personagem_id = $_SESSION['personagem'];
                        $sql = "SELECT * FROM personagens WHERE id = :personagem_id AND jogador = :user_id";
                        $stmt = $pdo->prepare($sql);
                        $stmt->bindParam(':personagem_id', $personagem_id, PDO::PARAM_INT);
                        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_STR);
                        $stmt->execute();
                        
                        if ($stmt->rowCount() > 0) {
                            $row = $stmt->fetch(PDO::FETCH_ASSOC);
                            $_SESSION['personagem_nome'] = $row['personagem'];
                            $_SESSION['local'] = $row['local'];
                            $paralisado = $row['paralisado'];
                            $prata = $row['prata'];
                            $soldados = $row['soldados'];
                            $carne = $row['carne'];
                            $_SESSION['carne'] = $carne;
                            $madeira = $row['madeira'];
                            $_SESSION['madeira'] = $madeira;
                            $_SESSION['soldados'] = $soldados;
                            $_SESSION['prata'] = $prata;
                            $atk = $row['atk'];
                            $_SESSION['atk'] = $atk;
                            $def = $row['def'];
                            $_SESSION['def'] = $def;
                            $cla = $row['cla'];
                            $_SESSION['cla'] = $cla;
                            $situacao = $row['situacao'];
                            $_SESSION['situacao'] = $situacao;
                            $datamovimentacao = $row['datamovimentacao'];
                            $_SESSION['datamovimentacao'] = $datamovimentacao;



                            // Obter informações do local
                            $local = $_SESSION['local'];
                            $sql = "SELECT tipo, n, l, s, o FROM mapasmed WHERE nome = :local";
                            $stmt = $pdo->prepare($sql);
                            $stmt->bindParam(':local', $local, PDO::PARAM_STR);
                            $stmt->execute();
                            
                            if ($stmt->rowCount() > 0) {
                                $local_info = $stmt->fetch(PDO::FETCH_ASSOC);
                                $tipolocal = $local_info['tipo'];
                                $norte = $local_info['n'];
                                $leste = $local_info['l'];
                                $sul = $local_info['s'];
                                $oeste = $local_info['o'];
                            }
                            
                            echo '<div class="character-info">';
                            echo '<div class="info-card">';
                            echo '<h3>Informações</h3>';
                            echo '<p><strong>Nome:</strong> '.$row['personagem'].'</p>';
                            echo '<p><strong>Reputação:</strong> '.$row['reputacao'].'</p>';
                            echo '<p><strong>Local:</strong> '.$row['local'].'</p>';
                            echo '<p><strong>Situação:</strong> '.$row['situacao'].'</p>';
                            if ($situacao != "livre") {
                                echo '<p><strong>Término:</strong> '.date('d/m/Y H:i', strtotime($paralisado)).'</p>';
                            }
                            echo '</div>';
                            
                            echo '<div class="info-card">';
                            echo '<h3>Recursos</h3>';
                            echo '<p><strong>Ouro:</strong> '.$row['ouro'].'</p>';
                            echo '<p><strong>Prata:</strong> '.$row['prata'].'</p>';
                            echo '<p><strong>Carne:</strong> '.$row['carne'].'</p>';
                            echo '<p><strong>Madeira:</strong> '.$row['madeira'].'</p>';
                            echo '</div>';
                            
                            echo '<div class="info-card">';
                            echo '<h3>Força</h3>';
                            echo '<p><strong>Soldados:</strong> '.$row['soldados'].'</p>';
                            echo '<p><strong>Ataque:</strong> '.$row['atk'].'</p>';
                            echo '<p><strong>Defesa:</strong> '.$row['def'].'</p>';
                            echo '<p><strong>Clã:</strong> '.$row['cla'].'</p>';
                            echo '</div>';
                            echo '</div>';

// xxxxxxxxxxxxxxx
// Verifica se há um personagem selecionado na sessão
if (isset($_SESSION['personagem'])) {
    // Primeiro, obtemos o nome do personagem selecionado
    $sqlPersonagem = "SELECT personagem FROM personagens WHERE id = :personagem_id";
    $stmtPersonagem = $pdo->prepare($sqlPersonagem);
    $stmtPersonagem->bindParam(':personagem_id', $_SESSION['personagem'], PDO::PARAM_INT);
    $stmtPersonagem->execute();
    $personagem = $stmtPersonagem->fetch(PDO::FETCH_ASSOC);
    
    if ($personagem) {
        $nomePersonagem = $personagem['personagem'];
        
        // Consulta para buscar ações relacionadas ao personagem selecionado
        $sqlMessages = "SELECT 
                            id,
                            acao, 
                            dataehora,
                            tipoacao,
                            origem,
                            jogador,
                            vz
                        FROM acoespersonagens 
                        WHERE personagem = :personagem
                        ORDER BY dataehora DESC 
                        LIMIT 15";
        
        $stmtMessages = $pdo->prepare($sqlMessages);
        $stmtMessages->bindParam(':personagem', $nomePersonagem, PDO::PARAM_STR);
        $stmtMessages->execute();
        $messages = $stmtMessages->fetchAll(PDO::FETCH_ASSOC);
        
        // Atualizar as mensagens não visualizadas (vz = 0)
        $idsParaAtualizar = [];
        foreach ($messages as $message) {
            if ($message['vz'] == 0) {
                $idsParaAtualizar[] = $message['id'];
            }
        }
        
        if (!empty($idsParaAtualizar)) {
            $placeholders = implode(',', array_fill(0, count($idsParaAtualizar), '?'));
            $sqlUpdate = "UPDATE acoespersonagens SET vz = 1 WHERE id IN ($placeholders)";
            $stmtUpdate = $pdo->prepare($sqlUpdate);
            $stmtUpdate->execute($idsParaAtualizar);
        }
    } else {
        $messages = [];
    }
} else {
    $messages = [];
}
?>

<div class="messages-container">
    <h2>Últimas Ações</h2>
    <?php if (!empty($messages)): ?>
        <?php foreach ($messages as $message): ?>
            <div class="message" style="<?= ($message['vz'] == 0) ? 'color: blue;' : '' ?>">
                <div class="message-content"><?= htmlspecialchars($message['acao']) ?></div>
                <div class="message-time"><?= date('d/m/Y H:i', strtotime($message['dataehora'])) ?></div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="message">Nenhuma ação recente.</div>
    <?php endif; ?>


   
</div>


<?php
if (!empty($_SESSION['msg'])) {
    echo '<div class="messages-container" style="
        color: #FFD700; /* Amarelo dourado */
        font-weight: bold; /* Negrito */
        text-shadow: 2px 2px 4px #000000; /* Sombra preta */
        background-color: rgba(0, 0, 0, 0.7); /* Fundo semi-transparente */
        padding: 10px;
        border-radius: 5px;
        border-left: 3px solid #FFD700;
    ">' . 
    htmlspecialchars($_SESSION['msg']) . 
    '</div>';
    
    $_SESSION['msg'] = ''; // Limpa a mensagem após exibir
}
?>

<style>
    .message {
        padding: 8px;
        border-bottom: 1px dashed #ccc;
        margin-bottom: 10px;
    }
    
    .message-content {
        font-weight: bold;
        margin-bottom: 5px;
    }
    
    .message-time {
        font-size: 0.8em;
        color: #666;
    }
</style>
<?php
        //  xxxxxxxxxx                  
                        }
                    }
                } else {
                    echo '<p>Nenhum personagem ativo encontrado.</p>';
                }
                ?>
            </div>
        </div>

        
        
        <!-- Mapa da Cidade -->
        <h2>Mapa de Dervian</h2>
        <div class="map-container">
            <?php
            $local = isset($_SESSION['local']) ? $_SESSION['local'] : '';
            $sql = "SELECT nome, tipo FROM mapasmed LIMIT 36";
            $stmt = $pdo->query($sql);
            
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $nome = $row["nome"];
                $tipo = $row["tipo"];
                $isCurrent = ($nome == $local);
                
                echo '<div class="map-square" onclick="showLocationDescription(\''.$nome.'\')">';
                echo '<img class="map-image" src="'.$tipo.'.png" alt="'.$nome.'">';
                echo '<p class="map-name">'.$nome.'</p>';
                if ($isCurrent) {
                    echo '<div class="map-personagem"><img src="personagem.png" alt="Seu personagem"></div>';
                }
                echo '</div>';
            }
            ?>
        </div>
        
        <!-- Modal para descrição do local -->
        <div id="locationModal" class="modal">
            <div class="modal-content">
                <span class="close-modal" onclick="closeModal()">&times;</span>
                <h2 id="modalLocationName"></h2>
                <p id="modalLocationDescription"></p>
            </div>
        </div>
        
        <!-- Ações do Personagem -->
        <div class="actions-section">
            <!-- Movimentação -->
            <div class="action-group">
                <h2>Movimentação</h2>
                
                <?php if (isset($situacao) && ($situacao == "livre" || $situacao == '')): ?>
                    <form action="moverperson.php" method="post">
                        <select name="direcao" class="btn">
                            <option value="<?php echo $norte; ?>">Norte</option>
                            <option value="<?php echo $leste; ?>">Leste</option>
                            <option value="<?php echo $sul; ?>">Sul</option>
                            <option value="<?php echo $oeste; ?>">Oeste</option>
                        </select>
                        <button type="submit" class="btn" name="mover" onclick="return confirm('Tem certeza que deseja mover?')">Mover</button>
                    </form>
              
                   
               <!-- No seu código HTML, procure pelo botão "Quem está no local" e substitua por: -->
               <?php if (isset($tipolocal) && $tipolocal != "city"): ?>
<button type="button" class="" onclick="abrirModalPersonagens()" style=" display: inline-block;
            padding: 12px 24px;
            margin: 5px;
            background: var(--azul-escuro);
            color: var(--branco);
            border: 3px solid var(--azul-vivo);
            border-radius: 8px;
            font-family: 'MedievalSharp', cursive;
            font-size: 1.1rem;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;">Quem está no local</button>
<?php endif; ?>

                <?php else: ?>
                    <p>Personagem ocupado: <?php echo $situacao; ?></p>
                    
    <?php 
                        if ($situacao == "trabalhando") {echo "Você e seus soldados estão trabalhando<br><br>";}
                        elseif ($situacao == "caçando") {echo "Você e seus soldados estão caçando<br><br>";}
                        
                        elseif ($situacao == "pegando madeira") {echo "Você e seus soldados estão pegando madeira<br><br>";}
                        elseif ($situacao == "treinandoATK") {echo "Você e seus soldados estão treinando o ataque";}
                        elseif ($situacao == "treinandoDEF") {echo "Você e seus soldados estão treinando a defesa";}
                        elseif ($situacao == "escondido") {echo "Vocês foram atacados, perderam a batalha, fugiram e se esconderam<br><br>";}
                        elseif ($situacao == "fugindo e reagrupando soldados") {echo "Vocês efetuaram um ataque mal sucediso<br>agora então fugindo, se esscondendo e se reagrupando<br><br>";}
                        elseif ($situacao == "reagrupando soldados") {echo "Vocês efetuaram um ataque bem sucediso<br>agora seus soldados estão se reagrupando<br><br>";}
                       
                        ?>
<p>Término: 
    <?php 
    if (!empty($paralisado) && strtotime($paralisado)) {
        echo date('d/m/Y H:i', strtotime($paralisado));
    } else {
        echo "Não definido";
    }
    ?>
</p>
                    <?php
                    $horarioAtual = date('Y-m-d H:i:s');
                    if ($horarioAtual >= $paralisado) {
                        $action = '';
                        $buttonText = '';
                        
                        if ($situacao == "trabalhando") {
                          $action = "pegarpg.php";
                            $buttonText = "Pegar Pagamento";
                        } elseif ($situacao == "caçando") {
                            $action = "finalisarcaca.php";
                            $buttonText = "Finalizar Caçada";
                        }
                        
                        elseif ($situacao == "pegando madeira") {
                                      $action = "finalisarlenha.php";
                            $buttonText = "Finalizar Coleta";
                        }

                        elseif ($situacao == "treinandoATK") {
                                      $action = "finalisartreinoatk.php";
                            $buttonText = "Finalizar treinamento";
                        }

                        elseif ($situacao == "treinandoDEF") {
                            $action = "finalisartreinodef.php";
                  $buttonText = "Finalizar treinamento";
              }

                        

                     elseif ($situacao == "escondido") {
                         $action = "jogo/aparecer.php";
                        $buttonText = "Agrupar e aparecer";
                    }
                    elseif ($situacao == "fugindo e reagrupando soldados") {
                        $action = "personagemlivre.php";
                        $buttonText = "Reagrupar e aparecer";}
                    elseif ($situacao == "reagrupando soldados") {
                        $action = "personagemlivre.php";
                        $buttonText = "Reagrupar e aparecer";
                    }
                   
                        
                        if ($action && $buttonText) {
                            echo '<form action="'.$action.'" method="POST">';
                            echo '<input type="hidden" name="local" value="treino">';
                            echo '<button type="submit" class="btn btn-success" name="treinar">'.$buttonText.'</button>';
                            echo '</form>';
                        }


                    }
                    ?>
                <?php endif; ?>
            </div>
            
         <!-- Ações na Cidade -->
            <?php if (isset($tipolocal) && $tipolocal == "city"): ?>
                <div class="action-group">
                    <h2>Ações na Cidade</h2>
                    <?php if (isset($situacao) && $situacao == "livre"): ?>
                        <form action="trabalhar.php" method="POST">
                            <input type="hidden" name="local" value="trabalhar">
                            <button type="submit" class="btn" name="trabalhar" onclick="return confirm('Tem certeza? Seu personagem ficará inativo por 5 minutos!')">Trabalhar</button>
                        </form>
                        
                        <form action="contratar.php" method="POST">
                            <h3>Contratar Soldados (80 pratas cada)</h3>
                            <input type="number" name="quantidade" min="1"     placeholder="Qtd"
           style="
               width: 80px;
               text-align: center;
               background-color: black;
               color: white;
               border: 1px solid white;
               padding: 5px;
           " required>
                            <button type="submit" class="btn" name="contratar" onclick="return confirm('Confirmar contratação?')">Contratar</button>
                        </form>
                        
                        <?php if ($soldados >= "1"): ?>
                            <form action="dispensarsoldados.php" method="POST">
                                <h3>Dispensar soldados</h3>
                                <input type="number" name="quantidade" min="1" max="<?php echo $soldados; ?>" placeholder="Quantidade"   style="
               width: 80px;
               text-align: center;
               background-color: black;
               color: white;
               border: 1px solid white;
               padding: 5px;
           " required>
                                <input type="hidden" name="item" value="carne">
                                <button type="submit" class="btn" name="vendercarne" onclick="return confirm('Confirmar venda?')">Dispensar</button>
                            </form>
                        <?php endif; ?>

                        <?php if ($carne >= "1"): ?>
                            <form action="vendercarne.php" method="POST">
                                <h3>Vender Carne (<?php echo $precocarne; ?> pratas cada)</h3>
                                <input type="number" name="quantidade" min="1" max="<?php echo $carne; ?>" placeholder="Quantidade"   style="
               width: 80px;
               text-align: center;
               background-color: black;
               color: white;
               border: 1px solid white;
               padding: 5px;
           " required>
                                <input type="hidden" name="item" value="carne">
                                <button type="submit" class="btn" name="vendercarne" onclick="return confirm('Confirmar venda?')">Vender Carne</button>
                            </form>
                        <?php endif; ?>
                        
                        <?php if ($madeira >= "1"): ?>
                            <form action="vendermadeira.php" method="POST">
                                <h3>Vender Madeira (<?php echo $precomadeira; ?> pratas cada)</h3>
                                <input type="number" name="quantidade" min="1" max="<?php echo $madeira; ?>" placeholder="Quantidade"   style="
               width: 80px;
               text-align: center;
               background-color: black;
               color: white;
               border: 1px solid white;
               padding: 5px;
           " required>
                                <input type="hidden" name="item" value="madeira">
                                <button type="submit" class="btn" name="vendermadeira" onclick="return confirm('Confirmar venda?')">Vender Madeira</button>
                            </form>
                        <?php endif; ?>

                    <?php endif; ?>
                </div>
            <?php endif; ?>
            
            <!-- Ações no Campo -->
            <?php if (isset($tipolocal) && $tipolocal == "campo" && isset($situacao) && $situacao == "livre"): ?>
                <div class="action-group">
                    <h2>Treinamento</h2>
                    <form action="treinaratk.php" method="POST">
                        <input type="hidden" name="item" value="atk">
                        <button type="submit" class="btn" name="treinar" onclick="return confirm('Treinar ataque por 7 minutos?')">Treinar Ataque</button>
                    </form>
                    
                    <form action="treinardef.php" method="POST">
                        <input type="hidden" name="item" value="def">
                        <button type="submit" class="btn" name="treinar" onclick="return confirm('Treinar defesa por 7 minutos?')">Treinar Defesa</button>
                    </form>
                </div>
            <?php endif; ?>
            
            <!-- Ações na Mata -->
            <?php if (isset($tipolocal) && $tipolocal == "mata" && isset($situacao) && $situacao == "livre"): ?>
                <div class="action-group">
                    <h2>Ações na Floresta</h2>
                    <form action="caca.php" method="POST">
                        <input type="hidden" name="item" value="caca">
                        <button type="submit" class="btn" name="caca" onclick="return confirm('Caçar por 4 minutos?')">Caçar</button>
                    </form>
                    
                    <form action="lenhar.php" method="POST">
                        <input type="hidden" name="item" value="lenhar">
                        <button type="submit" class="btn" name="lenhar" onclick="return confirm('Coletar madeira por 7 minutos?')">Coletar Madeira</button>
                    </form>
                </div>
            <?php endif; ?>
            
            <!-- Combate -->
<!-- Substitua a seção de Combate por este código -->
<?php if ($_SESSION['situacao'] !== 'escondido' && $_SESSION['situacao'] !== 'fugindo e reagrupando soldados'): ?>
<!-- Combate -->
<div class="action-group">
    <div style="height: 340px; width: 100%; overflow: hidden;">
        <iframe id="chatIframe" src="somensagenspersonagens.php" style="width: 100%; height: 100%; border: none;" onload="iniciarMonitoramentoScroll()"></iframe>
    </div>
    
    <div style="height: 200px; transform: translateY(-24px);">
        <iframe id="botoesChatIframe" src="botoeschatpersonagens.php" style="width: 100%; height: 100%; border: none;"></iframe>
    </div>
</div>
<?php endif; ?>

</div>
<div class="footer">
    ⚔️ Medieval Fantasy ⚔️
</div>

    
    
<!-- Adicione este modal no final do seu HTML, antes do fechamento do container -->
<div id="modalPersonagens" class="modal">
    <div class="modal-content" style="width: 80%; max-width: 650px;">
        <span class="close-modal" onclick="fecharModalPersonagens()">&times;</span>
        <div id="conteudoModal"></div>
    </div>
</div>

<script>
function abrirModalPersonagens() {
    const modal = document.getElementById('modalPersonagens');
    const conteudo = document.getElementById('conteudoModal');
    
    // Mostra o modal com um loader
    modal.style.display = 'block';
    conteudo.innerHTML = '<p style="text-align: center; color: white;">Carregando...</p>';
    
    // Faz a requisição para a página
    fetch('jogo/quemestanolocal.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'local=' + encodeURIComponent('<?php echo isset($local) ? $local : ''; ?>')
    })
    .then(response => response.text())
    .then(data => {
        conteudo.innerHTML = data;
    })
    .catch(error => {
        conteudo.innerHTML = '<p style="color: red;">Erro ao carregar informações.</p>';
    });
}

function fecharModalPersonagens() {
    document.getElementById('modalPersonagens').style.display = 'none';
}

// Fechar modal ao clicar fora
window.onclick = function(event) {
    const modal = document.getElementById('modalPersonagens');
    if (event.target == modal) {
        fecharModalPersonagens();
    }
}
</script>
    <script>
        function confirmarSaida() {
            if (confirm("Tem certeza que deseja sair?")) {
                window.location.href = "logout.php";
            }
        }
        
        function confirmarAtaque() {
            return confirm("Tem certeza que deseja atacar? Esta ação pode ter consequências!");
        }
        
        // Atualizar a página a cada 30 segundos para atualizar status
        setTimeout(function(){
            location.reload();
        }, 30000);
        
        // Modal para descrição do local
        function showLocationDescription(locationName) {
            fetch('?location=' + encodeURIComponent(locationName))
                .then(response => response.text())
                .then(description => {
                    document.getElementById('modalLocationName').textContent = locationName;
                    document.getElementById('modalLocationDescription').textContent = description;
                    document.getElementById('locationModal').style.display = 'block';
                });
        }
        
        function closeModal() {
            document.getElementById('locationModal').style.display = 'none';
        }
        
        // Fechar modal ao clicar fora
        window.onclick = function(event) {
            if (event.target == document.getElementById('locationModal')) {
                closeModal();
            }
        }
    </script>

    
<script>
// Função para recarregar o iframe de mensagens periodicamente
function recarregarIframeChat() {
    const iframe = document.getElementById('chatIframe');
    const iframeWindow = iframe.contentWindow;
    
    try {
        // Salva a posição atual do scroll
        const currentScroll = iframeWindow.scrollY || iframe.contentDocument.body.scrollTop;
        const scrollHeight = iframe.contentDocument.body.scrollHeight;
        const atBottom = (currentScroll >= scrollHeight - iframe.contentDocument.body.clientHeight - 10);
        
        // Só recarrega se o usuário estiver no final ou não tiver rolado para cima
        if (atBottom || !userScrolledUp) {
            // Corrigindo a concatenação da URL
            const separator = iframe.src.includes('?') ? '&' : '?';
            iframe.src = iframe.src + separator + 'scroll_position=' + currentScroll + '&t=' + Date.now();
            
            // Adiciona um timestamp para evitar cache
        }
    } catch (e) {
        console.log("Erro ao recarregar iframe:", e);
        // Recarrega mesmo com erro, mas sem tentar manter a posição
        iframe.src = iframe.src.split('?')[0] + '?t=' + Date.now();
    }
    
    // Agenda a próxima atualização
    setTimeout(recarregarIframeChat, 5000);
}

// Inicia a atualização automática
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(atualizarChat, 5000);

    // Ajusta a altura do iframe quando a página pai for redimensionada
    window.addEventListener('resize', function() {
        const iframe = document.getElementById('chatIframe');
        iframe.style.height = iframe.contentWindow.document.body.scrollHeight + 'px';
    });
});

// Função para receber mensagem do iframe (opcional)
window.receberMensagemDoChat = function(mensagem) {
    console.log('Mensagem do chat:', mensagem);
};
</script>
</body>
</html>